<?php
error_reporting(E_ALL ^ E_WARNING);

include("bl_Common.php");

$link = Connection::dbConnect();

$type        = Utils::sanitaze_var($_POST['type'], $link);
if (isset($_POST['name'])) { $name        = Utils::sanitaze_var($_POST['name'], $link); }
if (isset($_POST['description'])) { $description = Utils::sanitaze_var($_POST['description'], $link); }
if (isset($_POST['usage'])) { $usage       = Utils::sanitaze_var($_POST['usage'], $link); }
if (isset($_POST['products'])) { $products    = Utils::sanitaze_var($_POST['products'], $link); }
if (isset($_POST['creator'])) { $creator     = Utils::sanitaze_var($_POST['creator'], $link); }
if (isset($_POST['expiration'])) { $expiration  = Utils::sanitaze_var($_POST['expiration'], $link); }
$hash        = Utils::sanitaze_var($_POST['hash'], $link);

const TABLE_NAME = 'bl_game_vouchers';

if ($hash == Utils::get_secret_hash('')) {
    
    switch ($type) {
        
        case 1: // create voucher
            $sql = "SELECT * FROM " . TABLE_NAME . " WHERE name='{$name}'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if (mysqli_num_rows($result) <= 0) {
                
                mysqli_free_result($result);
                $sql = "INSERT INTO " . TABLE_NAME . " (name, description, usage_limit, products, creator, expiration) VALUES ('{$name}', '{$description}', '{$usage}', '{$products}', '{$creator}', '{$expiration}')";
                $result = mysqli_query($link, $sql) or die(mysqli_error($link) . $sql);
                
                if ($result) {
                    http_response_code(202);
                } else {
                    http_response_code(204);
                }
                
            } else {
                // a voucher with that name already exist
                http_response_code(205);
            }
            break;
        case 2: // get vouchers list
            
            $sql = "SELECT * FROM " . TABLE_NAME . " ORDER BY id DESC LIMIT {$usage}";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if ($result) {
                
                $rows = array();
                while ($r = mysqli_fetch_assoc($result)) {
                    $rows[] = $r;
                }
                echo json_encode($rows);
                http_response_code(202);
                
            }
            break;
        case 3: // redeem voucher
            
            $sql = "SELECT * FROM " . TABLE_NAME . " WHERE name = '{$name}'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            // voucher doesn't exist in database
            if (mysqli_num_rows($result) <= 0) {
                http_response_code(204);
                exit();
            }
            
            $rows = mysqli_fetch_assoc($result);
            
            if ($rows['expiration'] != "unlimited") {
                $expirationDate = date("m/d/Y", strtotime($rows['expiration']));
                $nowDate        = gmdate("m/d/Y");
                
                if ($nowDate >= $expirationDate) {
                    http_response_code(203);
                    exit();
                }
            }
            
            // max redeems reached
            $maxUsages = intval($rows['usage_limit']);
            if ($maxUsages > 0) {
                if (intval($rows['usages']) >= $maxUsages) {
                    http_response_code(205);
                    exit();
                }
            }
            
            $vid             = $rows['id'];
            $voucher_product = 'voucher.' . $vid;
            
            $sql = "SELECT id FROM " . PURCHASES_DB . " WHERE product_id = '{$voucher_product}' AND user_id = '{$creator}'";
            $queryResult = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            // voucher already redeem by this user
            if (mysqli_num_rows($queryResult) > 0) {
                http_response_code(208);
                exit();
            }
            
            mysqli_free_result($queryResult);
            $sql = "INSERT INTO " . PURCHASES_DB . " (product_id, receipt, user_id) VALUES ('{$voucher_product}', 'voucher_redeem', '{$creator}')";
            
            if (mysqli_query($link, $sql) or die(mysqli_error($link))) {
                
                $sql = "UPDATE " . TABLE_NAME . " SET usages=usages+1 WHERE id='{$vid}'";
                $queryResult = mysqli_query($link, $sql) or die(mysqli_error($link));
                if ($queryResult) {
                    
                    $rows['usages'] = intval($rows['usages']) + 1;
                    echo json_encode($rows);
                    http_response_code(202);
                }
            }
            break;
        case 4: // delete voucher
            
            $sql = "DELETE FROM " . TABLE_NAME . " WHERE id = '{$name}'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if ($result) {
                http_response_code(202);
            } else {
                http_response_code(204);
            }
            break;
        default:
            http_response_code(404);
            break;
    }
    
} else {
    http_response_code(401);
}

mysqli_close($link);
?>