<?php
error_reporting(E_ALL ^ E_WARNING);

include ("bl_Common.php");
include_once ("bl_Functions.php");

const TABLE_NAME = 'bl_game_news';
const IMG_DIR = 'img/news/';

if (isset($_POST['type']))
{
    $type = $_POST['type'];
}
else
{
    http_response_code(406);
    exit();
}
$hash = $_POST['hash'];

if ($hash != Utils::get_secret_hash(''))
{
    http_response_code(406);
    exit();
}

$link = Connection::dbConnect();
$function = new Functions($link);

switch ($type)
{
    case 1:
        createNew(false);
    break;
    case 2:
        getNewsList();
    break;
    case 3:
        deleteNew();
    break;
    case 4:
        createNew(true);
    break;
}

function createNew($isEdit)
{

    global $link;
    global $function;

    $title = Utils::sanitaze_var($_POST['title'], $link);
    $short_body = Utils::sanitaze_var($_POST['short_body'], $link);
    $action_id = Utils::sanitaze_var($_POST['action_id'], $link);
    $action_data = Utils::sanitaze_var($_POST['action_data'], $link);
    $end_date = Utils::sanitaze_var($_POST['end_date'], $link);
    $image_url = Utils::sanitaze_var($_POST['image_url'], $link);
    if ($isEdit)
    {
        $id = Utils::sanitaze_var($_POST['id'], $link);
    }

    if (isset($_FILES['newImg']))
    {
        $newImg = $_FILES['newImg'];
        $saveDir = IMG_DIR . $newImg['name'];

        if (!file_exists((IMG_DIR)))
        {
            mkdir(IMG_DIR, 0755, true);
        }

        if (move_uploaded_file($newImg['tmp_name'], $saveDir))
        {
            // succeed uploading the image.
            $image_url = $newImg['name'];
        }
        else
        {
            echo "Couldn't upload the image.";
        }
    }

    $end_date_sql = "DATE(NOW()) + INTERVAL " . $end_date . " DAY";
    if ($end_date == 0 || $end_date == "0")
    {
        $end_date_sql = "0";
    }

    if (!$isEdit)
    {
        $sql = "INSERT INTO " . TABLE_NAME . " (title, short_body, action_id, action_data, end_date, img_url) 
    VALUES ('$title', '$short_body', " . $action_id . ", '$action_data', " . $end_date_sql . ", '$image_url')";
    }
    else
    {
        $sql = "UPDATE " . TABLE_NAME . " SET title='$title', short_body='$short_body', action_id='$action_id', action_data='$action_data', end_date=" . $end_date_sql . ", img_url='$image_url' 
        WHERE id='$id'";
    }

    $result = $function->Query($sql);

    if ($result)
    {
        http_response_code(200);
    }
    else
    {
        http_response_code(406);
    }
}

function getNewsList()
{

    global $link;
    global $function;

    if (session_status() === PHP_SESSION_NONE)
    {
        session_start();
    }

    $sessionId = 0;
    if (isset($_SESSION['newsid']))
    {
        $sessionId = $_SESSION['newsid'];
    }
    $sessionId++;
    $_SESSION['newsid'] = $sessionId;
    session_write_close();

    if ($sessionId >= 10)
    {
        $sessionId = 0;

        $sql = "DELETE FROM " . TABLE_NAME . " WHERE end_date != 0 AND end_date < now()";
        $function->Query($sql);
    }

    $limit = Utils::sanitaze_var($_POST['max'], $link);
    $sql = "SELECT * FROM " . TABLE_NAME . " ORDER BY id DESC LIMIT " . $limit;
    $result = $function->Query($sql);

    // if there's not news created.
    if (mysqli_num_rows($result) <= 0)
    {
        http_response_code(204);
        exit();
    }

    $news = array();
    while ($row = $result->fetch_assoc())
    {
        $news[] = $row;
    }
    echo json_encode($news);
}

function deleteNew()
{

    global $link;
    global $function;

    $id = Utils::sanitaze_var($_POST['id'], $link);
    $sql = "DELETE FROM " . TABLE_NAME . " WHERE id = " . $id;
    $result = $function->Query($sql);
    if ($result)
    {
        http_response_code(200);
    }
    else
    {
        http_response_code(406);
    }
}
?>
